package org.msh.tb.bd.tbforms.query.tb12;

import org.msh.tb.bd.Quarter;
import org.msh.tb.bd.tbforms.query.TBFormQueryUtils;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.Workspace;

import javax.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Mauricio Santos on 18/04/2017.
 */
public class TBForm12Table1Query implements TbFormQuery {

    @Override
    public List<Object[]> queryDB(Tbunit tbunit, AdministrativeUnit adminUnit, Workspace workspace, Quarter selectedQuarter, EntityManager em) {
        List<Object[]> result = new ArrayList<Object[]>();
        String queryStr;

        // Smear Super Column - 0 is the identifier for this 'kind of query'
        queryStr =  "select 0, c.patientType, c.previouslyTreatedType, p.gender, c.followUpSmearStatus, count (*) "
                + " from TbCaseBD c join c.patient p "
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) ) "
                + " and p.gender is not null and c.state is not null and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.infectionSite = 0 and c.caseDefinition = 0 and c.followUpSmearStatus in (0,1) "
                + " group by c.patientType, c.previouslyTreatedType, p.gender, c.followUpSmearStatus ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Outcomes Super Column - 1 is the identifier for this 'kind of query'
        queryStr = "select 1, c.patientType, c.previouslyTreatedType, p.gender, c.state, count (*) " +
                " from TbCaseBD c join c.patient p "
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) ) "
                + " and p.gender is not null and c.state is not null and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.infectionSite = 0 and c.caseDefinition = 0 "
                + " and c.followUpSmearStatus = 2 "
                + " group by c.patientType, c.previouslyTreatedType, p.gender, c.state ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        // Total Registered Super Column - 2 is the identifier for this 'kind of query'
        queryStr = "select 2, c.patientType, c.previouslyTreatedType, p.gender, count (*) "
                + " from TbCase c join c.patient p "
                + " where c.registrationDate between :iniDate and :endDate %restriction%"
                + " and (c.patientType in (0,48) or ( c.patientType = 44 and c.previouslyTreatedType in (1,45,46,47) ) ) "
                + " and p.gender is not null and c.state is not null and c.classification = 0 and c.diagnosisType = 1 "
                + " and c.infectionSite = 0 and c.caseDefinition = 0 "
                + "group by c.patientType, c.previouslyTreatedType, p.gender ";
        result.addAll(TBFormQueryUtils.createQuery(queryStr,
                tbunit,
                adminUnit,
                workspace,
                selectedQuarter,
                em).getResultList());

        return result;
    }

}
